/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.server;

import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.indication.client.HSCSSLSocketCreator;
import com.ibm.hsc.indication.client.HSCSocket;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.indication.server.HSCListener;
import java.net.ServerSocket;
import java.net.Socket;

public class HSCConnListener
extends Thread {
    private int mPort = 9197;
    private HSCEventIndicationMgr mEim;

    public HSCConnListener(HSCEventIndicationMgr hSCEventIndicationMgr, int n) {
        this.mEim = hSCEventIndicationMgr;
        if (n != -1) {
            this.mPort = n;
        }
    }

    private HSCSSLSocketCreator getSSLSockCreator() {
        try {
            Class<?> clazz = Class.forName("com.ibm.hsc.indication.client.HSCSSLSocketCreatorImpl");
            HSCSSLSocketCreator hSCSSLSocketCreator = (HSCSSLSocketCreator)clazz.newInstance();
            return hSCSSLSocketCreator;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
            return null;
        }
    }

    public void run() {
        Object object;
        ServerSocket serverSocket = null;
        try {
            object = this.getSSLSockCreator();
            serverSocket = object.createSSLServerSocket(this.mPort, 1000);
            if (serverSocket == null) {
                serverSocket = new ServerSocket(this.mPort);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
            throw new RuntimeException(throwable.getMessage());
        }
        while (true) {
            try {
                while (true) {
                    System.out.println("bef accept");
                    object = serverSocket.accept();
                    ((Socket)object).setSoTimeout(500);
                    System.out.println("new connection accepted");
                    HSCSocket hSCSocket = new HSCSocket((Socket)object, true);
                    System.out.println("after created HSCSocket");
                    this.mEim.addListenerSite(new HSCListener(hSCSocket));
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(System.out);
                HSCLogUtils.serverLog(throwable, HSCLogUtils._IndicationClassLogInfo);
                continue;
            }
            break;
        }
    }
}

